// InputIPAddress.cpp : implementation file
//

#include "stdafx.h"
#include "defsfile.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CInputIPAddress Dialog


CInputIPAddress::CInputIPAddress(CWnd* pParent /*=NULL*/)
	: CDialog(CInputIPAddress::IDD, pParent)
{
	//{{AFX_DATA_INIT(CInputIPAddress)
	m_szIPAddress = _T("");
	m_iConnect = 0;
	m_wHeight = 480;
	m_uiWidth = 640;
	m_uiMachine = 0;
	m_uiCom = 1;
	//}}AFX_DATA_INIT
}


void CInputIPAddress::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CInputIPAddress)
	DDX_Control(pDX, IDC_SPIN_COM, m_spinCom);
	DDX_Control(pDX, IDC_SPIN_MACHINE, m_spinMachine);
	DDX_Control(pDX, IDC_CMB_STOP, m_cmbStop);
	DDX_Control(pDX, IDC_CMB_SPEED, m_cmbSpeed);
	DDX_Control(pDX, IDC_CMB_PARITY, m_cmbParity);
	DDX_Control(pDX, IDC_CMB_DATA, m_cmbData);
	DDX_Control(pDX, IDC_CMB_COM_TERMINATE, m_cmbTerm);
	DDX_Control(pDX, IDC_CMB_COM_SUMCHECK, m_cmbSum);
	DDX_Control(pDX, IDC_CMB_COM_NAK, m_cmbNak);
	DDX_Control(pDX, IDC_CMB_COM_FORM, m_cmbForm);
	DDX_Control(pDX, IDC_CMB_COM_ACK, m_cmbAck);
	DDX_Control(pDX, IDC_SPIN_WIDTH, m_spinWidth);
	DDX_Control(pDX, IDC_SPIN_HEIGHT, m_spinHeight);
	DDX_Text(pDX, IDC_INPUT_IP_EDIT, m_szIPAddress);
	DDX_Radio(pDX, IDC_RADIO_ETHER, m_iConnect);
	DDX_Text(pDX, IDC_EDIT_HEIGHT, m_wHeight);
	DDV_MinMaxUInt(pDX, m_wHeight, 1, 1200);
	DDX_Text(pDX, IDC_EDIT_WIDTH, m_uiWidth);
	DDV_MinMaxUInt(pDX, m_uiWidth, 1, 1600);
	DDX_Text(pDX, IDC_EDIT_MACHINE, m_uiMachine);
	DDV_MinMaxUInt(pDX, m_uiMachine, 0, 31);
	DDX_Text(pDX, IDC_EDIT_COM, m_uiCom);
	DDV_MinMaxUInt(pDX, m_uiCom, 1, 256);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CInputIPAddress, CDialog)
	//{{AFX_MSG_MAP(CInputIPAddress)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CInputIPAddress Message Handler

BOOL CInputIPAddress::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	GotoDlgCtrl( GetDlgItem(IDC_INPUT_IP_EDIT) );

	m_spinMachine.SetRange( 0, 31 ) ;
	m_spinWidth.SetRange( 1, 1600 ) ;
	m_spinHeight.SetRange( 1, 1200 ) ;
	m_spinCom.SetRange( 1, 256 ) ;

	m_cmbSpeed.SetCurSel( 2 ) ;
	m_cmbData.SetCurSel( 1 ) ;
	m_cmbParity.SetCurSel( 0 ) ;
	m_cmbStop.SetCurSel( 0 ) ;

	m_cmbForm.SetCurSel( 0 ) ;
	m_cmbTerm.SetCurSel( 0 ) ;
	m_cmbSum.SetCurSel( 1 ) ;
	m_cmbAck.SetCurSel( 1 ) ;
	m_cmbNak.SetCurSel( 1 ) ;

	return FALSE ;
}

void CInputIPAddress::OnOK() 
{
	if( !UpdateData() )
	{
		return ;
	}

	CString strSpeed = _T("") ;
	int iSpeed = 0 ;
	m_cmbSpeed.GetLBText( m_cmbSpeed.GetCurSel(), strSpeed ) ;
	_stscanf( (LPCTSTR)strSpeed, _T("%d"), &iSpeed ) ; 

	m_stSioConfig.stMemPortConfig.wBaudrate100 = (WORD)(iSpeed/100) ;
	m_stSioConfig.stMemPortConfig.byPort = (BYTE)m_uiCom ;
	switch( m_cmbParity.GetCurSel() )
	{
	default :
	case 0 :
		m_stSioConfig.stMemPortConfig.byParity = (BYTE)PTY_NONE ;		break ;
	case 1 :
		m_stSioConfig.stMemPortConfig.byParity = (BYTE)PTY_EVEN ;		break ;
	case 2 :
		m_stSioConfig.stMemPortConfig.byParity = (BYTE)PTY_ODD ;		break ;
	}
	m_stSioConfig.stMemPortConfig.byByteSize = (m_cmbData.GetCurSel()==0)?7:8 ;
	m_stSioConfig.stMemPortConfig.byStopBits = (m_cmbData.GetCurSel()==0)?STB_1:STB_2 ;
	
	m_stSioConfig.stMemLinkSetting.bAscii = (m_cmbForm.GetCurSel()%2==0)?true:false ;
	m_stSioConfig.stMemLinkSetting.bCrLf = (m_cmbTerm.GetCurSel()==0)?true:false ;
	m_stSioConfig.stMemLinkSetting.bOneByOne = (m_cmbForm.GetCurSel()<2)?true:false ;
	m_stSioConfig.stMemLinkSetting.byMachineNum = (BYTE)m_uiMachine ;
	m_stSioConfig.stMemLinkSetting.b2Wire = false ;
	m_stSioConfig.stMemLinkSetting.bExtCheckSum = (m_cmbSum.GetCurSel()==0)?true:false ;
	m_stSioConfig.stMemLinkSetting.bAck = (m_cmbAck.GetCurSel()==0)?true:false ;
	m_stSioConfig.stMemLinkSetting.bNak = (m_cmbNak.GetCurSel()==0)?true:false ;
	
	CDialog::OnOK();
}
